using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;
using System.Drawing;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class InteractiveSelector:Selector
  {
    [Export]
    public Trillean isPointable = Trillean.Any;

    [Export]
    public Trillean pointableEnabled = Trillean.Any;

    [Export]
    public Trillean isGrabbable = Trillean.Any;

    [Export]
    public Trillean grabbableEnabled = Trillean.Any;

    [Export]
    public Trillean isInteractable = Trillean.Any;

    [Export]
    public Trillean interactableEnabled = Trillean.Any;


    public override bool Selects( Node node )
    {
      if ( ! Matches<Pointable>( node, isPointable, pointableEnabled ) )
      {
        return false;
      }

      if ( ! Matches<Grabbable>( node, isGrabbable, grabbableEnabled ) )
      {
        return false;
      }

      if ( ! Matches<Interactable>( node, isInteractable, interactableEnabled ) )
      {
        return false;
      }

      return true;
    }

    bool Matches<T>( Node node, Trillean isType, Trillean isEnabled ) where T:Node,iEnablable
    {
      var childNode = Nodes.Find<T>( node );

      if ( ! TrilleanLogic.Matches( isType, childNode != null ) )
      {
        return false;
      }
      

      if ( ! TrilleanLogic.Matches( isEnabled, childNode != null && childNode.IsEnabled() ) )
      {
        return false;
      }    

      return true;
    }

  }
}