using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  public partial class LODCameraDistanceRule:LODLevelVisibilityRule
  {
    [Export]
    public float minDistance;

    [Export]
    public float maxDistance;

    public override bool Evaluate( LODNode lodNode )
    { 
      return Range.Contains( minDistance, maxDistance, lodNode.distance );
    }
  }
  
}