using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class LODLevel:Resource
  {    
    [Export]
    public LODLevelVisibilityRule[] visibilityRules = new LODLevelVisibilityRule[ 0 ];

    [Export]
    public Mesh mesh;

    [Export]
    public Material material;

    public bool Evaluate( LODNode lodNode )
    {
      for ( int i = 0; i < visibilityRules.Length; i++ )
      {
        if ( ! visibilityRules[ i ].Evaluate( lodNode ) )
        {
          return false;
        }
      }

      return true;
    }
  }
}