using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori.PointClouds
{
  public class Point
  { 
    public Vector3 position;
    public Color color;
    public Vector3 normal;
    public Vector2 uv;

    public Point Lerp( Point point, float amount )
    {
      var p = new Point();
      
      p.position = position.Lerp( point.position, amount );
      p.normal = normal.Lerp( point.normal, amount ).Normalized();
      p.uv = uv.Lerp( point.uv, amount );
      p.color = color.ToVector4().Lerp( point.color.ToVector4(), amount ).ToColor();      

      return p;
    }


    public static Point AsAverage( List<Point> points )
    {
      var p = new Point();

      var color = new Vector4();

      for ( int i = 0; i < points.Count; i++ )
      {
        var d = 1f / ( i + 1 );
        p.position += d * ( points[ i ].position - p.position );
        p.normal += d * ( points[ i ].normal - p.normal );
        p.uv += d * (  points[ i ].uv - p.uv );
        color += d * ( points[ i ].color.ToVector4() - color );
      }

      p.normal = p.normal.Normalized();
      p.color = color.ToColor();

      return p;
    }
  }
}