using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  public enum LocaleCode
  {
    af, // Afrikaans (South Africa, Namibia)
    am, // Amharic (Ethiopia)
    ar, // Arabic (Saudi Arabia, Egypt, UAE, Iraq, Morocco, Algeria, Jordan, and many more)
    az, // Azerbaijani (Azerbaijan)
    be, // Belarusian (Belarus)
    bg, // Bulgarian (Bulgaria)
    bn, // Bengali (Bangladesh, India)
    bs, // Bosnian (Bosnia and Herzegovina)
    ca, // Catalan (Spain - Catalonia, Andorra)
    cs, // Czech (Czech Republic)
    cy, // Welsh (Wales - UK)
    da, // Danish (Denmark, Greenland)
    de, // German (Germany, Austria, Switzerland, Liechtenstein, Belgium)
    el, // Greek (Greece, Cyprus)
    en, // English (UK, US, Australia, Canada, India, South Africa, and many more)
    es, // Spanish (Spain, Mexico, Argentina, Colombia, and many more)
    et, // Estonian (Estonia)
    eu, // Basque (Spain - Basque Country, France - Basque areas)
    fa, // Persian (Iran, Afghanistan, Tajikistan)
    fi, // Finnish (Finland)
    fil, // Filipino (Philippines)
    fr, // French (France, Canada, Belgium, Switzerland, many African countries)
    ga, // Irish (Ireland)
    gl, // Galician (Spain - Galicia)
    gu, // Gujarati (India, some in Pakistan)
    he, // Hebrew (Israel)
    hi, // Hindi (India, Fiji)
    hr, // Croatian (Croatia, Bosnia and Herzegovina)
    hu, // Hungarian (Hungary, some parts of Romania and Slovakia)
    hy, // Armenian (Armenia)
    id, // Indonesian (Indonesia)
    @is, // Icelandic (Iceland)
    it, // Italian (Italy, Switzerland, San Marino, Vatican City)
    ja, // Japanese (Japan)
    ka, // Georgian (Georgia)
    kk, // Kazakh (Kazakhstan)
    km, // Khmer (Cambodia)
    kn, // Kannada (India - Karnataka)
    ko, // Korean (South Korea, North Korea)
    ky, // Kyrgyz (Kyrgyzstan)
    lo, // Lao (Laos)
    lt, // Lithuanian (Lithuania)
    lv, // Latvian (Latvia)
    mk, // Macedonian (North Macedonia)
    ml, // Malayalam (India - Kerala)
    mn, // Mongolian (Mongolia)
    mr, // Marathi (India - Maharashtra)
    ms, // Malay (Malaysia, Brunei, Singapore, Indonesia)
    mt, // Maltese (Malta)
    my, // Burmese (Myanmar)
    ne, // Nepali (Nepal, India - Sikkim and West Bengal)
    nl, // Dutch (Netherlands, Belgium, Suriname, Caribbean Netherlands)
    no, // Norwegian (Norway)
    pa, // Punjabi (India, Pakistan)
    pl, // Polish (Poland)
    ps, // Pashto (Afghanistan, Pakistan)
    pt, // Portuguese (Portugal, Brazil, Mozambique, Angola, and others)
    ro, // Romanian (Romania, Moldova)
    ru, // Russian (Russia, Belarus, Kazakhstan, Kyrgyzstan, and others)
    si, // Sinhala (Sri Lanka)
    sk, // Slovak (Slovakia)
    sl, // Slovenian (Slovenia)
    sq, // Albanian (Albania, Kosovo, North Macedonia)
    sr, // Serbian (Serbia, Bosnia and Herzegovina, Montenegro)
    sv, // Swedish (Sweden, Finland - Åland)
    sw, // Swahili (Tanzania, Kenya, Uganda, DRC, and others)
    ta, // Tamil (India - Tamil Nadu, Sri Lanka, Singapore, Malaysia)
    te, // Telugu (India - Andhra Pradesh, Telangana)
    th, // Thai (Thailand)
    tr, // Turkish (Turkey, Cyprus)
    uk, // Ukrainian (Ukraine)
    ur, // Urdu (Pakistan, India)
    uz, // Uzbek (Uzbekistan)
    vi, // Vietnamese (Vietnam)
    zh, // Chinese (China, Taiwan, Singapore, Malaysia)
  }
}
