using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class LocaleLabel3D:Label3D, iLocalizable
  {
    LocalizedString _locale;

    [Export]
    public LocalizedString locale
    {
      get
      {
        return _locale;
      }

      set
      {
        _locale = value;
        UpdateLocalization();
      }
    }

    [Export]
    public bool refreshText 
    {
      get => false;
      set { if ( value ) UpdateLocalization(); }
    }

    public void UpdateLocalization()
    {
      Text = locale.currentValue;
    }

  }
}