using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/LocaleManager.svg")]
  public partial class LocaleManager:Node
  {
    LocaleCode _languageLocale = LocaleCode.en;
    static LocaleCode _editorLanguageLocale = LocaleCode.en;

    [Export]
    public LocaleCode languageLocale
    {
      get => _languageLocale;
      set { _languageLocale = value; _editorLanguageLocale = value; UpdateLocalization(); }
    }

    public override void _Ready()
    {
      // RJLog.Log( "_Ready >>", _languageLocale ); 
      UpdateLocalization();
    }

    public void UpdateLocalization()
    {
      // RJLog.Log( "Updating Language >>>", _languageLocale ); 
      this.ForEachInRoot<iLocalizable>( i => { i.UpdateLocalization(); } );
    }

    public static LocaleCode currentLanguage 
    {
      get
      {
        if ( Engine.IsEditorHint() )
        {
          return _editorLanguageLocale;
        }

        

        var lm = Unique<LocaleManager>.Get();
        var lc = LocaleCode.en;

        if ( lm != null )
        {
          lc = lm.languageLocale;
        }

        // RJLog.Log( "currentLanguage", lc );

        return lc;
      }
    }
  }
}