using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/LocalizedString.svg")]
  public partial class LocaleText:LocalizedString
  {    
    [Export(PropertyHint.MultilineText)]
    public string en;

    [ExportGroup("Translations")]
    [Export]
    public LocaleTextEntry[] entries = new LocaleTextEntry[ 0 ]; 

    [ExportGroup("Context")]
    [Export(PropertyHint.MultilineText)]
    public string context;    

    public static LocaleText Create( string en )
    {
      var lt = new LocaleText();
      lt.en = en;
      
      return lt;
    }

    public override string GetLocalizedString( LocaleCode localeCode )
    {
      if ( localeCode == LocaleCode.en || entries == null )
      {
        return en;
      }

      
      var entry =  Arrays.Find( entries, e => e.code == localeCode );

      if ( entry != null )
      {
        return entry.content;
      }

      return en;

    }

  }
}