using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/LocalizedString.svg")]
  public abstract partial class LocalizedString:Resource
  {
    public virtual string GetLocalizedString( LocaleCode localeCode )
    {
      return "";
    }

    public string currentValue 
    {
      get 
      {
        return GetLocalizedString( LocaleManager.currentLanguage );
      }
    }

    public static string Get( LocalizedString ls, string alternative = "")
    {
      return ls == null ? alternative : ls.currentValue;
    }



  }
}