using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using System.Linq;
using Godot;

namespace Rokojori
{ 
  public enum MessageType
  {
    Verbose,
    Info,
    Warning,
    Error
  }

  public class Message
  {
    public MessageType type;
    public string content;

    public override string ToString()
    {
      return "[" + type + "] " + content;
    }

    public static Message Create( MessageType type, string content )
    {
      var m = new Message();
      m.type = type;
      m.content = content;      
      return m;
    }

    public static Message Verbose( string content )
    {
      return Create( MessageType.Verbose, content );
    }

    public static Message Info( string content )
    {
      return Create( MessageType.Info, content );
    }

    public static Message Warning( string content )
    {
      return Create( MessageType.Warning, content );
    }

    public static Message Error( string content )
    {
      return Create( MessageType.Error, content );
    }

  }

  public class Messages
  {
    public static int GetLevel( MessageType type )
    {
      if ( MessageType.Verbose == type )
      {
        return 0;
      }

      if ( MessageType.Info == type )
      {
        return 1;
      }

      if ( MessageType.Warning == type )
      {
        return 2;
      }

      if ( MessageType.Error == type )
      {
        return 3;
      }

      return -1;
    }

    public static bool HasError( List<Message> messages )
    {
      return messages.Find( m => m.type == MessageType.Error ) != null;
    }

    public static bool HasWarningsOrErrors( List<Message> messages )
    {
      return messages.Find( m => m.type == MessageType.Error || m.type == MessageType.Warning ) != null;
    }

    public static List<Message> GetMessagesWithLevel( List<Message> messages, int level )
    {
      return Lists.Filter( messages, m => GetLevel( m.type ) >= level );
    }

    public static List<Message> GetErrors( List<Message> messages)
    {
      return GetMessagesWithLevel( messages, GetLevel( MessageType.Error ) );
    }

    public static void Verbose( List<Message> messages, string content )
    {
      messages.Add( Message.Verbose( content ) );
    }

    public static void Info( List<Message> messages, string content )
    {
      messages.Add( Message.Info( content ) );
    }

    public static void Warning( List<Message> messages, string content )
    {
      messages.Add( Message.Warning( content ) );
    }

    public static void Error( List<Message> messages, string content )
    {
      messages.Add( Message.Error( content ) );
    }
  }
}