using System.Collections;
using System.Collections.Generic;
using Godot;

namespace Rokojori
{
  public class Bezier
  {
    public static float Compute( float t, List<float> values )
    {
      var result = 0f;

      var degree = values.Count;

      for ( int i = 0; i < values.Count; i++ )
      {
        var bp = BernsteinPolynom.Compute( degree, i, t );
        result += values[ i ] * bp;
      }

      return result;
    }

    public static Vector2 Compute( float t, List<Vector2> values )
    {
      var result = Vector2.Zero;

      var degree = values.Count;

      for ( int i = 0; i < values.Count; i++ )
      {
        var bp = BernsteinPolynom.Compute( degree, i, t );
        result += values[ i ] * bp;
      }

      return result;
    }

    public static Vector3 Compute( float t, List<Vector3> values )
    {
      var result = Vector3.Zero;

      var degree = values.Count;

      for ( int i = 0; i < values.Count; i++ )
      {
        var bp = BernsteinPolynom.Compute( degree, i, t );
        result += values[ i ] * bp;
      }

      return result;
    }
  }
}