using Godot;
using System.Collections;
using System.Collections.Generic;

namespace Rokojori
{
	public class Capsule2
	{
    public Vector2 start = Vector2.Zero;
    public Vector2 end = Vector2.Zero;
    public float radius = 1;

    public Capsule2( Vector2 start, Vector2 end, float radius )
    {
      this.start = start;
      this.end = end;
      this.radius = radius;
    }    

    public Capsule2 Copy()
    {
      return new Capsule2( start, end, radius );
    }

    public Vector2 center
    {
      get { return start.Lerp( end, 0.5f ); }
    }

    public Line2 centerLine
    {
      get { return new Line2( start, end ); }
    }

    public float DistanceToPoint( Vector2 p )
    {
      var lineDistance = centerLine.DistanceToPoint( p );
      return Mathf.Max( 0, lineDistance - radius );
    } 


	}
}

