using Godot;
using System.Collections;
using System.Collections.Generic;

namespace Rokojori
{
	public class Capsule3
	{
    public Vector3 start = Vector3.Zero;
    public Vector3 end = Vector3.Zero;
    public float radius = 1;

    public Capsule3( Vector3 start, Vector3 end, float radius )
    {
      this.start = start;
      this.end = end;
      this.radius = radius;
    }    

    public Capsule3 Copy()
    {
      return new Capsule3( start, end, radius );
    }

    public Vector3 center
    {
      get { return start.Lerp( end, 0.5f ); }
    }

    public Line3 centerLine
    {
      get { return new Line3( start, end ); }
    }

    public float DistanceToPoint( Vector3 p )
    {
      var lineDistance = centerLine.DistanceToPoint( p );
      return Mathf.Max( 0, lineDistance - radius );
    } 

    public float DistanceTo( Capsule3 other )
    {
      var lineDistance = centerLine.DistanceToLine( other.centerLine );

      return Mathf.Max( 0, lineDistance - ( radius + other.radius ) );
    }


	}
}

