using Godot;
using System.Collections;
using System.Collections.Generic;

namespace Rokojori
{
	public class Overlap3D
	{
    public static bool Has( Box3 a, Box3 b )
    {
      if ( ! Range.Overlap( a.min.Y, a.max.Y, b.min.Y, b.max.Y ) )
      {
        return false;
      }

      if ( ! Range.Overlap( a.min.X, a.max.X, b.min.X, b.max.X ) )
      {
        return false;
      }      

      if ( ! Range.Overlap( a.min.Z, a.max.Z, b.min.Z, b.max.Z ) )
      {
        return false;
      }

      return true;
    }

    public static bool Has( Sphere a, Sphere b )
    {
      return a.IntersectsSphere( b );
    }

    public static bool Has( Box3 a, Sphere b )
    {
      return a.SquareDistanceTo( b ) <= 0;
    }

    public static bool Has( Sphere a, Box3 b )
    {
      return b.SquareDistanceTo( a ) <= 0;
    }

    public static bool Has( Capsule3 a, Capsule3 b )
    {
      return a.DistanceTo( b ) <= 0;
    }

  }
}