using System.Collections;
using System.Collections.Generic;
using Godot;

namespace Rokojori
{

	public class SAT2
	{ 
    public static void Project( Vector2 normal, List<Vector2> points, Range outputProjectionRange )
    {
      var min =   float.MaxValue;
      var max = - float.MaxValue;

      for ( var i = 0; i < points.Count; i++ )
      {        
        var dot = Math2D.Dot( normal, points[ i ] );

        min = Mathf.Min( min, dot );
        max = Mathf.Max( max, dot );
      }

      outputProjectionRange.min = min;
      outputProjectionRange.max = max;
    }
        
    public static bool IsIntersecting( 
      List<Vector2> normalsA, List<Vector2> pointsA,
      List<Vector2> normalsB, List<Vector2> pointsB )
    {
      var projectionRangeA = new Range( 0, 1 );
      var projectionRangeB = new Range( 0, 1 );

      for ( var i = 0; i < normalsA.Count; i++ )
      {
        var axis = normalsA[ i ];

        Project( axis, pointsA, projectionRangeA );
        Project( axis, pointsB, projectionRangeB );

        if ( ! projectionRangeA.Overlaps( projectionRangeB ) )
        {
          return false;
        }
      } 

      for ( var i = 0; i < normalsB.Count; i++ )
      {
        var axis = normalsB[ i ];
        Project( axis, pointsA, projectionRangeA );
        Project( axis, pointsB, projectionRangeB );

        if ( ! projectionRangeA.Overlaps( projectionRangeB ) )
        {
          return false;
        }
      } 

      return true;
    } 

	}
}

