using System.Collections;
using System.Collections.Generic;
using Godot;

namespace Rokojori
{
	public class Sphere
	{
    public Vector3 center = Vector3.Zero;
    public float radius = 1;

    public Sphere( Vector3 center, float radius )
    {
      this.center = center;
      this.radius = radius;
    }    

    public Sphere(){}

    public Sphere Create( Vector3 center, float radius )
    {
      var sphere = new Sphere();
      sphere.center = center;
      sphere.radius = radius;

      return sphere;
    } 

    public Sphere Copy()
    {
      return new Sphere( center, radius );
    }

    public float DistanceToPoint( Vector3 point )
    {
      return Mathf.Max( 0, ( point - center ).Length() - radius );
    }

    public bool ContainsPoint( Vector3 point )
    {
      return DistanceToPoint( point ) <= 0; 
    }

    public float DistanceToSphere( Sphere sphere )
    {
      var distance = sphere.center - center;
      var radiusBoth = sphere.radius + radius;
      return Mathf.Max( 0, distance.Length() - radiusBoth ); 
    }

    public bool IntersectsSphere( Sphere sphere )
    {
      return DistanceToSphere( sphere ) <= 0;
    }

    public Box3 CreateBox()
    {
      var offset = radius * Vector3.One;
      return Box3.Create( center -offset, center + offset );
    }
  

    public static Sphere ContainingBox( Box3 box )
    {
      if ( box == null )
      {
        return null;
      }
      
      return new Sphere( box.center, box.maxDistance / 2f );
    }

	}
}

