using System.Collections;
using System.Collections.Generic;
using Godot;

namespace Rokojori
{

  public class QuadraticBezier
  {
    public static float Compute(
      float t, 
      float p0, float p1, float p2
    )
    {
      var bp0 = ( 1 - t ) * ( 1 - t );
      var bp1 = 2 * ( 1 - t ) * t;
      var bp2 = t * t;

      return p0 * bp0 + p1 * bp1 + p2 * bp2;

    }

    public static Vector2 Compute(
      float t, 
      Vector2 p0, Vector2 p1, Vector2 p2
    )
    {
      var bp0 = ( 1 - t ) * ( 1 - t );
      var bp1 = 2 * ( 1 - t ) * t;
      var bp2 = t * t;

      return p0 * bp0 + p1 * bp1 + p2 * bp2;
    }

    public static Vector3 Compute(
      float t, 
      Vector3 p0, Vector3 p1, Vector3 p2
    )
    {
      var bp0 = ( 1 - t ) * ( 1 - t );
      var bp1 = 2 * ( 1 - t ) * t;
      var bp2 = t * t;

      return p0 * bp0 + p1 * bp1 + p2 * bp2;
    }   
      
  }


}