using System.Collections;
using System.Collections.Generic;
using Godot;

namespace Rokojori
{
	public class Range
	{
    public float min;
    public float max;
    
    public Range( float min, float max )
    {
      this.min = min;
      this.max = max;
    }

    public void EnsureCorrectness()
    {
      if ( max < min )
      {
        var b = max; max = min; min = b;
      }
    } 

    public bool Contains( float value )
    {
      return min <= value && value <= max;
    }

    public bool Overlaps( Range other )
    {
      if ( other.max < min ) { return false; }
      if ( other.min > max ) { return false; }
      
      if ( other.Contains( min ) || other.Contains( max ) ) 
      {
        return true;
      }

      if ( Contains( other.min ) || Contains( other.max ) ) 
      {
        return true;
      }

      return false;
    }

    public float center { get { return 0.5f * ( max + min ); } }
    public float range { get { return max - min; } }
    public float length { get { return max - min; } }

    public float DistanceTo( Range other )
    {
      var center = this.center;
      var otherCenter = other.center;

      var range = this.range;
      var otherRange = other.range;

      var distance = Mathf.Abs( center - otherCenter );

      return Mathf.Max( 0, distance - 0.5f * ( range + otherRange ) );
 
    }

    public Range Copy()
    {
      return new Range( min, max );
    }

    public float SampleAt( float normalized )
    {
      return min + ( max - min ) * normalized;
    }

    public static Range Of_01
    {
      get { return new Range( 0, 1 ); }
    }

    public static bool Contains( float min, float max, float value )
    {
      return min <= value && value <= max;
    }

    public static bool ContainsExclusive( float min, float max, float value )
    {
      return min < value && value < max;
    }

    public static bool ContainsExclusiveMax( float min, float max, float value )
    {
      return min <= value && value < max;
    }

    public static bool Overlap( float minA, float maxA, float minB, float maxB )
    {
      if ( maxB < minA ) { return false; }
      if ( minB > maxA ) { return false; }
      
      if ( Contains( minB, maxB, minA ) || Contains( minB, maxB, maxA ) ) 
      {
        return true;
      }

      if ( Contains( minA, maxA, minB ) || Contains( minA, maxA, maxB ) ) 
      {
        return true;
      }

      return false;
    
    }

    
	}
  
}

