using System.Collections;
using System.Collections.Generic;
using Godot;

namespace Rokojori
{
  public class RangeI
	{
    public int min;
    public int max;

    public RangeI( int min, int max )
    {
      this.min = min;
      this.max = max;
    }

    public void EnsureCorrectness()
    {
      if ( max < min )
      {
        var b = max; max = min; min = b;
      }
    } 

    public bool Contains( int value )
    {
      return min <= value && value <= max;
    }

    public bool Overlaps( RangeI other )
    {
      if ( other.max < min ) { return false; }
      if ( other.min > max ) { return false; }
      
      if ( other.Contains( min ) || other.Contains( max ) ) 
      {
        return true;
      }

      if ( Contains( other.min ) || Contains( other.max ) ) 
      {
        return true;
      }

      return false;
    }

    public RangeI Copy()
    {
      return new RangeI( min, max );
    }

    public int center { get { return ( max + min ) / 2; } }
    public int range { get { return max - min; } }
    public int length { get { return max - min; } }

    public static bool Contains( float min, float max, float value )
    {
      return min <= value && value <= max;
    }

    public static bool ContainsExclusive( float min, float max, float value )
    {
      return min < value && value < max;
    }

    public static bool ContainsExclusiveMax( float min, float max, float value )
    {
      return min <= value && value < max;
    }

    public static bool Overlap( float minA, float maxA, float minB, float maxB )
    {
      if ( maxB < minA ) { return false; }
      if ( minB > maxA ) { return false; }
      
      if ( Contains( minB, maxB, minA ) || Contains( minB, maxB, maxA ) ) 
      {
        return true;
      }

      if ( Contains( minA, maxA, minB ) || Contains( minA, maxA, maxB ) ) 
      {
        return true;
      }

      return false;
    
    }
  }
}