using System.Collections;
using System.Collections.Generic;
using Godot;

namespace Rokojori
{

  public class RationalCubicBezier
  {
    public static float Compute(
      float t, 
      float p0, float p1, float p2, float p3, 
      float w0, float w1, float w2, float w3
    )
    {
      var bp0 = ( 1 - t ) * ( 1 - t ) * ( 1 - t ) * w0;
      var bp1 = 3 * ( 1 - t ) * ( 1 - t ) * t * w1;
      var bp2 = 3 * ( 1 - t ) * t * t * w2;
      var bp3 = t * t * t * w3;

      var weighted = p0 * bp0 + p1 * bp1 + p2 * bp2 + p3 * bp3;

      var projection = bp0 + bp1 + bp2 + bp3;

      return weighted / projection;
    }

    public static Vector2 Compute(
      float t, 
      Vector2 p0, Vector2 p1, Vector2 p2, Vector2 p3, 
      float w0, float w1, float w2, float w3
    )
    {
      var bp0 = ( 1 - t ) * ( 1 - t ) * ( 1 - t ) * w0;
      var bp1 = 3 * ( 1 - t ) * ( 1 - t ) * t * w1;
      var bp2 = 3 * ( 1 - t ) * t * t * w2;
      var bp3 = t * t * t * w3;

      var weighted = p0 * bp0 + p1 * bp1 + p2 * bp2 + p3 * bp3;

      var projection = bp0 + bp1 + bp2 + bp3;

      return weighted / projection;
    }

    public static Vector3 Compute(
      float t, 
      Vector3 p0, Vector3 p1, Vector3 p2, Vector3 p3, 
      float w0, float w1, float w2, float w3
    )
    {
      var bp0 = ( 1 - t ) * ( 1 - t ) * ( 1 - t ) * w0;
      var bp1 = 3 * ( 1 - t ) * ( 1 - t ) * t * w1;
      var bp2 = 3 * ( 1 - t ) * t * t * w2;
      var bp3 = t * t * t * w3;

      var weighted = p0 * bp0 + p1 * bp1 + p2 * bp2 + p3 * bp3;

      var projection = bp0 + bp1 + bp2 + bp3;

      return weighted / projection;
    }


    public static Vector2 Compute( float t, Vector3 p0, Vector3 p1, Vector3 p2, Vector3 p3 )
    {
      var bp0 = ( 1 - t ) * ( 1 - t ) * ( 1 - t ) * p0.Z;
      var bp1 = 3 * ( 1 - t ) * ( 1 - t ) * t * p1.Z;
      var bp2 = 3 * ( 1 - t ) * t * t * p2.Z;
      var bp3 = t * t * t * p3.Z;

      var weighted = p0 * bp0 + p1 * bp1 + p2 * bp2 + p3 * bp3;

      var projection = bp0 + bp1 + bp2 + bp3;

      var result = weighted / projection;

      return new Vector2( result.X, result.Y );
    }

    public static Vector3 Compute( float t, Vector4 p0, Vector4 p1, Vector4 p2, Vector4 p3 )
    {
      var bp0 = ( 1 - t ) * ( 1 - t ) * ( 1 - t ) * p0.W;
      var bp1 = 3 * ( 1 - t ) * ( 1 - t ) * t * p1.W;
      var bp2 = 3 * ( 1 - t ) * t * t * p2.W;
      var bp3 = t * t * t * p3.W;

      var weighted = p0 * bp0 + p1 * bp1 + p2 * bp2 + p3 * bp3;

      var projection = bp0 + bp1 + bp2 + bp3;

      var result = weighted / projection;

      return new Vector3( result.X, result.Y, result.Z );
    }


    

    
  }


}