using Godot;
using System.Collections;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Rokojori
{
  public class NaviationMeshes
  {
    public static NavigationMesh FromMeshGeometry( MeshGeometry meshGeometry )
    {
      var mesh = new NavigationMesh();
      mesh.SetVertices( meshGeometry.vertices.ToArray() );
      
      for ( int i = 0; i < meshGeometry.indices.Count; i += 3 )
      {
        var triangle = new int[ 3 ];

        for ( int j = 0; j < 3; j ++ )
        {
          triangle[ j ] = meshGeometry.indices[ i ] + j;
        }        

        mesh.AddPolygon( triangle );
      }

      return mesh;
    }

    public static NavigationMesh FromTrianglePolygons( List<List<Vector3>> trianglePolygons )
    {
      var mesh = new NavigationMesh();

      var size = 0;      

      trianglePolygons.ForEach( p => size += p.Count );

      var vertices = new Vector3[ size ];

      var offset = 0;

      var polygons = new List<int[]>();

      trianglePolygons.ForEach( 
        p => 
        {
          var polygon = new int[ p.Count ];
          var polygonOfffset = offset;

          p.ForEach( v =>           
            { 
              polygon[ offset - polygonOfffset ] = offset;

              vertices[ offset ] = v; 

              offset++; 
              
            } 
          );

          polygons.Add( polygon );
          
        }
      );

      mesh.SetVertices( vertices );

      polygons.ForEach( p => mesh.AddPolygon( p ) ); 

      return mesh;
    }

  }

}