using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public class NetMember
  {
    public virtual void ReadMember( BitView view )
    {

    }

    public virtual void WriteMember( BitView view )
    {

    }
  }

  public class TypedNetMember<T>:NetMember
  {
    NetworkDataType<T> dataType;
    public T value;

    public TypedNetMember( NetworkDataType<T> dataType, T value )
    {
      this.dataType = dataType;
      this.value    = value;
    }

    public override void ReadMember( BitView view )
    {
      value = dataType.ReadData( view );
    }

    public override void WriteMember( BitView view )
    {
      dataType.WriteData( view, value );
    }

  }

  

}