using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public class NetBoolType:NetworkDataType<bool>
  {
    public bool ReadData( BitView view )
    {
      return view.ReadBit();
    }

    public void WriteData( BitView view, bool value )
    {
      view.WriteBit( value );
    }
  }

  public class NetBool:TypedNetMember<bool>
  {
    public NetBool( bool value ):base( Singleton<NetBoolType>.Get(), value ){}
  }


}