using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public class NetByteType:NetworkDataType<byte>
  {
    public byte ReadData( BitView view )
    {
      return view.ReadByte();
    }

    public void WriteData( BitView view, byte value )
    {
      view.WriteByte( value );
    }
  }

  public class NetByte:TypedNetMember<byte>
  {
    public NetByte( byte value ):base( Singleton<NetByteType>.Get(), value ){}
  }

  
}