using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public class NetFloatType:NetworkDataType<float>
  {
    public float ReadData( BitView view )
    {
      return view.ReadFloat();
    }

    public void WriteData( BitView view, float value )
    {
      view.WriteFloat( value );
    }
  }


  public class NetFloat:TypedNetMember<float>
  {
    public NetFloat( float value ):base( Singleton<NetFloatType>.Get(), value ){}
  }
}