using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public class NetIntType:NetworkDataType<int>
  {
    public int ReadData( BitView view )
    {
      return view.ReadInt();
    }

    public void WriteData( BitView view, int value )
    {
      view.WriteInt( value );
    }
  }

  public class NetInt:TypedNetMember<int>
  {
    public NetInt( int value ):base( Singleton<NetIntType>.Get(), value ){}
  }
}