using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public class NetIntVL8Type:NetworkDataType<int>
  {
    public int ReadData( BitView view )
    {
      return view.ReadUIntVL8();
    }

    public void WriteData( BitView view, int value )
    {
      view.WriteUIntVL8( value );
    }
  }

  public class NetIntVL8:TypedNetMember<int>
  {
    public NetIntVL8( int value ):base( Singleton<NetIntVL8Type>.Get(), value ){}
  }
}