using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public class NetListType<T>:NetworkDataType<List<T>>
  {
    public NetworkDataType<T> dataType;

    public List<T> ReadData( BitView view )
    {
      var num = view.ReadUIntVL8();
      var list = new List<T>( num );
      
      for ( int i = 0; i < num; i++ )
      {
        list.Add( dataType.ReadData( view ) );
      }

      return list;
    }

    public void WriteData( BitView view, List<T> list )
    {
      view.WriteUIntVL8( list.Count );
      
      for ( int i = 0; i < list.Count; i++ )
      {
        dataType.WriteData( view, list[ i ] );
      }
    }
  }

  public class NetList<T>:TypedNetMember<List<T>>
  {
    public NetList( List<T> value ):base( Singleton<NetListType<T>>.Get(), value ){}
  }
}