using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public class NetQuaternionType:NetworkDataType<Quaternion>
  {
    public Quaternion ReadData( BitView view )
    {
      return view.ReadQuaternion();
    }

    public void WriteData( BitView view, Quaternion value )
    {
      view.WriteQuaternion( value );
    }
  }

  public class NetQuaternion:TypedNetMember<Quaternion>
  {
    public NetQuaternion( Quaternion value ):base( Singleton<NetQuaternionType>.Get(), value ){}
  }
}