using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public class NetVector3Type:NetworkDataType<Vector3>
  {
    public Vector3 ReadData( BitView view )
    {
      return view.ReadVector3();
    }

    public void WriteData( BitView view, Vector3 value )
    {
      view.WriteVector3( value );
    }
  }

  public class NetVector3:TypedNetMember<Vector3>
  {
    public NetVector3( Vector3 value ):base( Singleton<NetVector3Type>.Get(), value ){}
  }
}