using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public partial class NetworkBackend:Node
  {
    protected NetworkSessionConnectionState _state;
    protected string serverIP = "127.0.0.1";
    protected int port = 1984;
    protected int maxMembers = 32;

    protected NetworkManager _manager;
    protected ExtendedNetworkSessionManager _sessionManager;
    protected ExtendedNetworkTransport _transport;

    public void InitializeBackend( 
      NetworkManager manager, 
      ExtendedNetworkSessionManager sessionManager,
      ExtendedNetworkTransport transport
    )
    { 
      _manager = manager;
      _sessionManager = sessionManager;
      _transport = transport;
    } 

    protected void AssignSessionRequestVariables( NetworkSessionRequest request )
    {
      if ( request == null )
      {
        return;
      }

      if ( request.serverIP != null )
      {
        serverIP = request.serverIP;
      }

      if ( request.port > 0 )
      {
        port = request.port;
      }   

      if ( request.maxMembers > 0 )
      {
        maxMembers = request.maxMembers;
      }
    } 

    public virtual void StartSession( NetworkSessionRequest sessionRequest )
    {

    }

    public virtual void JoinSession( NetworkSessionRequest sessionRequest )
    {

    }

    public virtual void LeaveSession()
    {

    }

    public virtual void SendMessage( byte[] bytes, List<int> targetMembers, bool reliable = true )
    {

    }

  }
}