using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  [Tool][GlobalClass]
  public partial class AddNetworkNodes:Action
  {
    [Export]
    public Node[] nodes = new Node[ 0 ];

    protected override void _OnTrigger()
    {
      RJLog.Log( "AddNetworkNodes" );

      for ( int i = 0; i < nodes.Length; i++ )
      {
        AddNodeAndChildren( nodes[ i ] );
      }
    }

    void AddNodeAndChildren( Node root )
    {
      var walker = new NodesWalker();

      var nm = Unique<NetworkManager>.Get();
      var rf = nm.references;

      walker.Iterate( root,
        n => 
        { 
          var isNetworkNode = typeof( INetworkNode ).IsAssignableFrom( n.GetType() );    

          if ( ! isNetworkNode )
          {
            return;
          }
         
          var inn = (INetworkNode) n;
          rf.AddMembersOf( inn );
                    
        }
      );
    }
  }
}