using Godot;
using Rokojori.Tools;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool] 
  [GlobalClass]  
  public partial class NetworkNode : Node, INetworkNode
  {
    [ExportGroup("Network Settings")]
    [Export]
    public NetworkTransportType networkType = NetworkTransportType.Never_Networked;
    public NetworkTransportType GetNetworkType(){ return networkType; }
 
    [Export]
    public int networkOwner;
    public int GetNetworkOwner(){ return networkOwner; }

    
    protected List<NetworkNodeMember> _networkNodeMembers = null;
    protected NetworkNodeSlot _networkNodeSlot = new NetworkNodeSlot();

    public virtual List<NetworkNodeMember> GetNetworkNodeMembers()
    {
      if ( _networkNodeMembers != null )
      {
        return _networkNodeMembers;
      }

      _networkNodeMembers = CreateNetworkNodeMembers();
      _networkNodeSlot.onMessage.AddAction( _OnNetworkMessageReceived );

      InitializeNetworkMembers();

      return _networkNodeMembers;
    }

    protected virtual List<NetworkNodeMember> CreateNetworkNodeMembers()
    {
      return new List<NetworkNodeMember>(){ _networkNodeSlot };
    }

    protected virtual void InitializeNetworkMembers()
    {
      for ( int i = 0; i < _networkNodeMembers.Count; i++ )
      {
        _networkNodeMembers[ i ]._SetNode( this );
      }
    }

    protected virtual void _OnNetworkMessageReceived( NetworkMessageEvent m )
    {

    }
  }
}