using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  public class NetworkNodeMemberReferences
  { 
    Dictionary<int,NetworkNodeMember> referencesMap = new Dictionary<int, NetworkNodeMember>();
    int counter = 1;

    public NetworkNodeMember GetMember( int id )
    {
      if ( ! referencesMap.ContainsKey( id ) )
      {
        return null;
      }
      
      return referencesMap[ id ];

    }

    public void AddMembersOf( INetworkNode node )
    {
      var members = node.GetNetworkNodeMembers();
      
      for ( int i = 0; i < members.Count; i++ )
      {
        if ( members[ i ].networkType == NetworkTransportType.Never_Networked )
        {
          continue;
        }

        if ( members[ i ].hasNetworkID )
        {
          continue;
        }        

        RJLog.Log( "Networked member", HierarchyName.Of( (Node)node ), i );

        var id = counter; 
        referencesMap[ id ] = members[ i ];
        members[ i ]._SetNetworkID( id );
        
        counter ++;
      }
    }
    
  }
}