using Godot;
using System.Collections.Generic;


namespace Rokojori
{  
  [Tool][GlobalClass]
  public partial class NetworkTransform3D:NetworkNode
  {
    [Export]
    public NetworkTransform3DType type;
    
    NetworkNodeSlot _positionSlot = new NetworkNodeSlot();
    NetworkNodeSlot _rotationSlot = new NetworkNodeSlot();
    NetworkNodeSlot _scaleSlot    = new NetworkNodeSlot();

    protected override List<NetworkNodeMember> CreateNetworkNodeMembers()
    {
      return new List<NetworkNodeMember>()
      {
        _networkNodeSlot,
        _positionSlot, 
        _rotationSlot,
        _scaleSlot
      };
    } 

    Vector3 _sendPosition = Vector3.Zero;
    Vector3 _sendRotation = Vector3.Zero; 
    Vector3 _sendScale    = Vector3.One;
    float   _sendTime     = 0;
    bool _idle            = true;

    
    public override void _Process( double delta )
    {
      if ( ! NetworkManager.IsInSession )
      {
        return;
      }

      if ( ! _networkNodeSlot.hasOwnedTransportType )
      {
        return;
      }

      if ( _networkNodeSlot.isOwnedLocally )
      {
        
      }
      else
      {

      }
    }
  }
}