using Godot;


namespace Rokojori
{
  public class NetworkTransportSettings
  {
    public static bool CanSend( NetworkTransportType type, int owner )
    {      
      if ( NetworkTransportType.Currently_Not_Networked == type )
      {
        return false;
      }

      if ( NetworkTransportType.From_Everybody_To_Everybody == type )
      {
        return true;
      }

      var nm = Unique<NetworkManager>.Get();
      
      if ( NetworkTransportType.Owned_By_One == type )
      {
        return nm.sessionManager.ownMemberIndex == owner;
      }

      if ( NetworkTransportType.Server_Only == type )
      {
        return nm.sessionManager.isServer;
      }

      return false;
    }

    public static bool CanReceive( NetworkTransportType type, int owner )
    {
      if ( NetworkTransportType.Currently_Not_Networked == type )
      {
        return false;
      }

      if ( NetworkTransportType.From_Everybody_To_Everybody == type )
      {
        return true;
      }

      var nm = Unique<NetworkManager>.Get();

      if ( NetworkTransportType.Owned_By_One == type )
      {
        return nm.sessionManager.ownMemberIndex != owner;
      }

       if ( NetworkTransportType.Server_Only == type )
      {
        return ! nm.sessionManager.isServer;
      }

      return false;
    }

  }
}
