
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public static class PhysicsBodies
  {
    public static bool IsInAir( this PhysicsBody3D physicsBody3D )
    {
      if ( physicsBody3D is RigidBody3D rb)
      {
        return false;
      }

      if ( physicsBody3D is CharacterBody3D cb)
      {
        return ! cb.IsOnFloor();
      }

      if ( physicsBody3D is PhysicalBone3D pb )
      {
        return false;
      }

      if ( physicsBody3D is StaticBody3D sb )
      {
        return false;
      }

      return false;
    }

    public static Vector3 GetVelocity( this PhysicsBody3D physicsBody3D )
    {
      if ( physicsBody3D is RigidBody3D rb)
      {
        return rb.LinearVelocity;
      }

      if ( physicsBody3D is CharacterBody3D cb)
      {
        return cb.Velocity;
      }

      if ( physicsBody3D is PhysicalBone3D pb )
      {
        return pb.LinearVelocity;
      }

      if ( physicsBody3D is StaticBody3D sb )
      {
        return sb.ConstantLinearVelocity;
      }

      return Vector3.Zero;
    }


    public static void SetVelocity( this PhysicsBody3D physicsBody3D, Vector3 velocity )
    {
      if ( physicsBody3D is RigidBody3D rb )
      {
        rb.LinearVelocity = velocity;
        return;
      }

      if ( physicsBody3D is CharacterBody3D cb)
      {
        cb.Velocity = velocity;
        return;
      }

      if ( physicsBody3D is PhysicalBone3D pb )
      {
        pb.LinearVelocity= velocity;
        return;
      }

      if ( physicsBody3D is StaticBody3D sb )
      {
        sb.ConstantLinearVelocity= velocity;
        return;
      }

    }
  }
}