using Godot;
using System.Collections;
using System.Collections.Generic;

namespace Rokojori
{
  public class PhysicsRayCast
  {
    public static CollisionData GetFirst( CharacterBody3D body, Vector3 from, Vector3 to )
    {
      var world = body.GetWorld3D();
      var rayParameters = new PhysicsRayQueryParameters3D
      {
        From = from,
        To = to,
        CollisionMask = body.CollisionMask,
        CollideWithAreas = false,
        CollideWithBodies = true
      };
      
      rayParameters.Exclude = [ body.GetRid() ];
      var hits = CollisionData.MultiRayCast( world, rayParameters, 1 );

      return hits.Count == 0 ? null : hits[ 0 ];
    }

    public static CollisionData GetFirst( CharacterBody3D body, Vector3 direction )
    {
      var from = body.GlobalPosition;
      var to = from + direction;

      return GetFirst( body, from, to );
    }

    public static int GetAll( List<CollisionData> outputCollisionData, CharacterBody3D body, Vector3 from, Vector3 to )
    {
      var world = body.GetWorld3D();
      var rayParameters = new PhysicsRayQueryParameters3D
      {
        From = from,
        To = to,
        CollisionMask = body.CollisionMask,
        CollideWithAreas = false,
        CollideWithBodies = true
      };

      rayParameters.Exclude = [ body.GetRid() ];
      return CollisionData.MultiRayCast( world, rayParameters, outputCollisionData );
    }

    public static int GetAll( List<CollisionData> outputCollisionData, CharacterBody3D body, Vector3 direction )
    {
      var from = body.GlobalPosition;
      var to = from + direction;

      return GetAll( outputCollisionData, body, from, to );
    }

  }
}