using Godot;
using System.Collections;
using System.Collections.Generic;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class Projectile:CharacterBody3D
  {
    [Export]
    public float speed = 0;

    [Export]
    public bool disableOnCollision = false;

    [Export]
    public bool disabled = false;

    [Export]
    public Collider collider;

    [Export]
    public Action onCollision;

    [Export]
    public bool runInEditor = false;


    public override void _PhysicsProcess( double delta )
    {
      if ( disabled || ( Engine.IsEditorHint() && ! runInEditor ) )
      {
        return;
      }

      var velocity = this.GlobalForward() * speed * (float)delta;

      var collision = MoveAndCollide( velocity );

      if ( collision == null )
      {
        return;
      }

      if ( collider != null)
      { 
        collider.TriggerOnCollisionEnter( this, collision );
      }

      Action.Trigger( onCollision );

      if ( disableOnCollision )
      {
        disabled = true;
      }
    }
  }
}