
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/WindManager.svg") ]
  public partial class TextureKMHWindSpeed:WindSpeed
  {   
    [Export]
    public float km_hour = 10;

    [Export]
    public Vector2 textureSizeInMeters = new Vector2( 2048, 2048 );

    public override float GetKMH()
    {
      return km_hour;
    }

    public override Vector2 GetNormalizedWindSpeedOffset( double delta, float minKMH, float maxKMH )
    {
      var clampedKM_Hour = Mathf.Clamp( km_hour, minKMH, maxKMH ); 
      var km_min = clampedKM_Hour / 60f;
      var km_sec = km_min / 60f;

      var km_offset = (float)( delta * km_sec );
      var m_offset = km_offset * 1000f;

      return ( Vector2.One * m_offset ) / textureSizeInMeters;

    }

    
  }
}