
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/WindManager.svg") ]
  public partial class WindToGPUParticles:Action
  {   
    [Export]
    public GpuParticles3D particles3D;

    [Export]
    public float maxKMH = 100;

    [Export]
    public float noWindRatio = 0.5f;

    [Export]
    public Vector3 noWindDirection = Vector3.Zero;

    [Export]
    public float windDirectionInfluence = 0.1f;

    [Export]
    public float noWindSpread = 45;

    [Export]
    public float windSpeedToSpread = 0.1f;

    [Export]
    public Vector2 noWindInitialVelocity = new Vector2( 0,1 );

    [Export]
    public Vector2 windSpeedToVelocity = new Vector2( 5, 50);


    protected override void _OnTrigger()
    {
      if ( particles3D == null )
      {
        return;
      }

      var processMaterial = (ParticleProcessMaterial) particles3D.ProcessMaterial;

      var wm = Unique<WindManager>.Get();

      var speed = wm.data.windSpeed.GetKMH();
      var dir = wm.data.windDirection.To3DXZ();

      particles3D.AmountRatio = Mathf.Lerp( noWindRatio, 1.0f, MathX.Clamp01( speed / maxKMH ) );
      
      processMaterial.Direction = noWindDirection + speed * dir * windDirectionInfluence;
      processMaterial.Spread = noWindSpread + speed * windSpeedToSpread;

      var velocity = noWindInitialVelocity + speed * windSpeedToVelocity;
      processMaterial.InitialVelocityMin = velocity.X;
      processMaterial.InitialVelocityMax = velocity.Y;


    }
  }
}