
using Godot;
using System.Threading.Tasks;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class FeatureModuleList: FeatureModule
  { 
    [Export]
    public FeatureModule[] features = [];

    public override async Task ProcessPass( PresetContext context )
    {
      if ( features == null )
      {
        return;
      }

      foreach ( var f in features )
      {
        if ( f == null )
        {
          continue;
        }

        await f.ProcessPass( context );
      }

      return;
    }
  }
}