
using Godot;
using System.Threading.Tasks;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class ThirdPersonCameraModule: FeatureModule
  { 

    public override async Task ProcessPass( PresetContext presetContext )
    {
      if ( PresetPass.Prefly == presetContext.pass )
      {
        if ( AppPreset.PresetErrorHandlingMode.Automatic_Fix == presetContext.appPreset.errorHandling )
        {
          presetContext.appPreset.mainModule.cameraManager = true;
        }
      }
      else if ( PresetPass.Process == presetContext.pass )
      {
        SetupThirdPersonCamera( presetContext );
      }

      return;
    }
     
    void SetupThirdPersonCamera( PresetContext presetContext )
    {
      var cameraManager = Unique<CameraManager>.Get();
      var slot = cameraManager.CreateChild<CameraSlot>( "Third Person Camera Slot" );

      var vCam = presetContext.root.CreateChild<ThirdPersonCamera>( "Third Person Camera" );

      slot.camera = vCam;
      slot.priority = 1;

      cameraManager.active = true;
      cameraManager.refreshSlots = true;
    } 
  }
}