
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class RenderQualitySettings:Node
  { 
    [ExportToolButton( "Set High")]
    public Callable setHighButton => Callable.From( ()=> { SetQuick( true ); });

    [ExportToolButton( "Set Low")]
    public Callable setLowButton => Callable.From( ()=> { SetQuick( false ); });

    public static void SetQuick( bool high )
    {
      ProjectSettings.SetSetting( "rendering/anti_aliasing/quality/msaa_3d", high ? 3 : 0  );
      ProjectSettings.SetSetting( "rendering/anti_aliasing/quality/use_debanding", high );
      
      ProjectSettings.SetSetting( "rendering/lights_and_shadows/positional_shadow/soft_shadow_filter_quality", high ? 5 : 0 );
      ProjectSettings.SetSetting( "rendering/lights_and_shadows/directional_shadow/soft_shadow_filter_quality", high ? 5 : 0 );
           
      ProjectSettings.SetSetting( "rendering/textures/default_filters/anisotropic_filtering_level", high ? 4 : 0  );
      ProjectSettings.SetSetting( "rendering/textures/decals/filter", high ? 5 : 3 );
      ProjectSettings.SetSetting( "rendering/textures/light_projectors/filter", high ? 5 : 3 );

      ProjectSettings.SetSetting( "rendering/camera/depth_of_field/depth_of_field_bokeh_quality", high ? 3 : 0 );
      ProjectSettings.SetSetting( "rendering/camera/depth_of_field/depth_of_field_bokeh_shape", high ? 2 : 0 );

      ProjectSettings.SetSetting( "rendering/environment/ssao/quality", high ? 4 : 0 );
      ProjectSettings.SetSetting( "rendering/environment/glow/upscale_mode", high ? 1 : 0 ); 
      ProjectSettings.SetSetting( "rendering/environment/subsurface_scattering/subsurface_scattering_quality", high ? 3 : 0 );
      ProjectSettings.SetSetting( "rendering/environment/ssil/quality", high ? 4 : 0 );	



      ProjectSettings.Save();
    }
  }
}