using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class TreeBranch:Resource
  { 
    [Export]
    public NodePath spline;

    [Export]
    public Vector3 start;

    [Export]
    public Vector3 end;

    [Export]
    public int startSeed;

    [Export]
    public Curve curve;


    public Spline GetSpline( Node node )
    {
      return node.GetNode( spline ) as Spline;
    }

    [Export]
    public int index = -1;
    
    [Export]
    public int parent = -1;

    [Export]
    public int level = -1;

    [Export]
    public int[] children = [];

    [Export]
    public float radius = 0;

    [Export]
    public float radius2 = 0;

    [Export]
    public float radius3 = 0;

    [Export]
    public int numRadi = 1;
    
    [Export]
    public float height = 0;
    
    [Export]
    public float branchPosition = 0;

    public Line3 GetLine3()
    {
      return new Line3( start, end );
    }
  }
}