using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class BakingOutput:Resource
  {
    [Export]
    public BakingTarget bakingTarget;
    
    [Export]
    public Texture2D bakedTexture;

    public static BakingOutput With( BakingTargetType type, Texture2D texture2D )
    {
      var  bo = new BakingOutput();
      bo.bakingTarget = new BakingTarget();
      bo.bakingTarget.type = type;
      bo.bakedTexture = texture2D;

      return bo;
    }
    
    public static BakingOutput Lit( Texture2D texture2D = null )
    {
      return With( BakingTargetType.Lit, texture2D );
    }

    public static BakingOutput Albedo( Texture2D texture2D = null )
    {
      return With( BakingTargetType.Albedo, texture2D );
    }


    public static BakingOutput Normals( Texture2D texture2D = null )
    {
      return With( BakingTargetType.Normals, texture2D );
    }

    public static BakingOutput Depth( Texture2D texture2D = null )
    {
      return With( BakingTargetType.Depth, texture2D );
    }

    public static BakingOutput UV( Texture2D texture2D = null )
    {
      return With( BakingTargetType.UV, texture2D );
    }

    public static BakingOutput ORM( Texture2D texture2D = null )
    {
      return With( BakingTargetType.ORM, texture2D );
    }

    public bool IsType( BakingTargetType type, string customType = null )
    {
      if ( type == BakingTargetType.Custom && bakingTarget.type == type )
      {
        return bakingTarget.customType == customType;
      }

      return type == bakingTarget.type;
    }
  }
}