using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class DepthBakingPass: _XX_BakingPass
  {
    public DepthBakingPass():base(){}

    protected override void CreateBakingOutputs()
    {
      bakingOutputs = [ BakingOutput.Depth() ];
    }

    protected override bool KeepsOriginalState()
    {
      return true;
    }

    protected override bool KeepsCompositors()
    {
      return false;
    }

    protected override async Task _Bake() 
    {
      Clear( BakingTargetType.Depth );

      multiBaker.AddCompositorEffect( new DepthViewEffect() );

      await multiBaker.RequestNextFrame();

      var texture = await GrabDilatedTexture( true, false );

      Set( BakingTargetType.Depth, texture );

      return;
    }

    void EnsureBakingOutputs()
    {
      bakingOutputs = [ BakingOutput.Lit() ];
    }
  }
}