using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class LitBakingPass: _XX_BakingPass
  {
    public LitBakingPass():base(){}

    protected override void CreateBakingOutputs()
    {
      bakingOutputs = [ BakingOutput.Lit() ];
    }

    protected override bool KeepsOriginalState()
    {
      return true;
    }

    protected override bool KeepsCompositors()
    {
      return true;
    }

    protected override async Task _Bake() 
    {
      Clear( BakingTargetType.Lit );

      await textureBaker.multiBaker.RequestNextFrame();

      var texture = await GrabDilatedTexture( true, true );

      Set( BakingTargetType.Lit, texture );

      return;
    }

    void EnsureBakingOutputs()
    {
      bakingOutputs = [ BakingOutput.Lit() ];
    }
  }
}