using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class _XX_MultiTextureBaker:Resource
  {
    protected MultiBaker _multiBaker;
    public MultiBaker multiBaker => _multiBaker;

    protected List<_XX_BakingPass> _passes;  

    protected void _SetPasses( params _XX_BakingPass[] passes )
    {
      _passes = [.. passes];

      _passes.ForEach( p => p.textureBaker = this );
    }

    protected virtual void _IntitializePasses()
    {

    }


    public List<_XX_BakingPass> GetPasses( MultiBaker multiBaker )
    {
      _multiBaker = multiBaker;

      if ( _passes != null )
      {
         return Lists.Filter( _passes, p => p.isEnabled );
      }

      _IntitializePasses();

      return Lists.Filter( _passes, p => p.isEnabled );
    }

  }
}