using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class GrabTexture:Node
  { 
    
    

    [Export]
    public Compositor compositor;

    [Export]
    public WorldEnvironment environment;

    [Export]
    public Camera3D camera3D;

    [ExportToolButton( "Grab Compositor From Camera")]
    public Callable GrabCompositorButton => Callable.From( 
      () => 
      {
        if ( camera3D != null )
        {
          compositor = camera3D.Compositor;
        }

        if ( environment != null )
        {
          compositor = environment.Compositor;
        }
        

        alphaGrabTestEffect = (AlphaGrabTestEffect) compositor.CompositorEffects[ compositorIndex ];
      } 
    );


    [Export]
    public int compositorIndex;

    [Export]
    public AlphaGrabTestEffect alphaGrabTestEffect;

    [ExportToolButton( "Grab Texture")]
    public Callable GrabTextureButton => Callable.From( 
      async () => 
      {
        var result = await alphaGrabTestEffect.GetImageTexture( async ()=> await this.RequestNextFrame() );

        if ( result == null )
        {
          this.LogError( "No texture" );
          return;
        }

        texture2D = result;
      } 
    );



    [Export]
    public Texture2D texture2D;

    public void Grab()
    {
      var effect = compositor.CompositorEffects[ compositorIndex ];

    }

  }
}